#include <algorithm>
#include <vector>
#include <iostream>
#include <stack>

using namespace std;
#define ll long long

void color_dfs(const vector<vector<int>>& directed_tree, vector<int>& colors, int node, int color)
{
	stack<pair<int, int>> to_visit;
	to_visit.push({ -1, node });
	colors[node] = color;
	while (!to_visit.empty())
	{
		int parent = to_visit.top().first;
		int node = to_visit.top().second;
		to_visit.pop();
		for (int child : directed_tree[node])
		{
			to_visit.push({ node, child });
			colors[child] = color;
		}
	}
}

int count_components_dfs_recursive(vector<int>& component_count, const vector<vector<int>>& directed_tree, const vector<int>& colors,
	int parent, int node, int parent_color)
{
	int count = (parent_color != colors[node]);
	for (int child: directed_tree[node])
	{
		count += count_components_dfs_recursive(component_count, directed_tree, colors, node, child, colors[node]);
	}
	component_count[node] = count;
	return count;
}

int count_components_dfs(const vector<vector<int>>& directed_tree, vector<int>& colors)
{
	stack<vector<int>> to_visit;
	to_visit.push({ -1, 1, -1}); // parent, node, parent color
	int component_count = 0;
	while (!to_visit.empty())
	{
		int parent = to_visit.top()[0];
		int node = to_visit.top()[1];
		int parent_color = to_visit.top()[2];
		to_visit.pop();
		if (parent_color != colors[node])
			component_count++;

		for (int child : directed_tree[node])
		{
			to_visit.push({ node, child, colors[node] });
		}
	}
	return component_count;
}

vector<int> bruteforce(const vector<vector<int>>& tree, vector<int>& colors, const vector<vector<int>> queries)
{
	// Rebuild the tree into a directed graph
	vector<vector<int>> directed_tree = vector<vector<int>>(tree.size());
	stack<pair<int, int>> to_visit;
	to_visit.push({ -1,1 });
	while (!to_visit.empty())
	{
		int parent = to_visit.top().first;
		int node = to_visit.top().second;
		to_visit.pop();
		for (int neighbor: tree[node])
		{
			if (neighbor != parent)
			{
				to_visit.push({node, neighbor});
				directed_tree[node].push_back(neighbor);
			}
		}
	}

	vector<int> solution = vector<int>(); solution.reserve(queries.size());
	for (auto query: queries)
	{
		color_dfs(directed_tree, colors, query[0], query[1]);
		solution.push_back(count_components_dfs(directed_tree, colors));
	}

	return solution;
}

vector<int> better_solution(const vector<vector<int>>& graph, vector<int>& colors, const vector<vector<int>> queries)
{
	// Rebuild the tree into a directed graph
	vector<int> parents(graph.size(), -1);
	vector<vector<int>> directed_tree = vector<vector<int>>(graph.size());
	stack<pair<int, int>> to_visit;
	to_visit.push({ -1,1 });
	while (!to_visit.empty())
	{
		int parent = to_visit.top().first;
		int node = to_visit.top().second;
		to_visit.pop();
		for (int neighbor : graph[node])
		{
			if (neighbor != parent)
			{
				to_visit.push({ node, neighbor });
				parents[neighbor] = node;
				directed_tree[node].push_back(neighbor);
			}
		}
	}

	vector<int> component_count(graph.size());
	count_components_dfs_recursive(component_count, directed_tree, colors, -1, 1, -1);
	
	vector<int> solution; solution.reserve(queries.size());
	for (auto query: queries)
	{
		int node = query[0];
		int color = query[1];

		int new_count = 1;
		if (color == colors[parents[node]])
			new_count = 0;
		
		int difference = new_count - component_count[node];
		component_count[node] = new_count;
		// Propagate the change to parents
		while (parents[node] > -1)
		{
			component_count[parents[node]] += difference;
			node = parents[node];
		}
		solution.push_back(component_count[1]);
	}
	return solution;
}

int main()
{
	int node_count, query_count;
	cin >> node_count >> query_count;
	vector<vector<int>> graph(node_count + 1);
	for (size_t i = 0; i < node_count-1; i++)
	{
		int a, b; cin >> a >> b;
		graph[a].push_back(b);
		graph[b].push_back(a);
	}
	vector<int> colors(node_count + 1);
	for (size_t i = 1; i < colors.size(); i++)
		cin >> colors[i];

	vector<vector<int>> queries(query_count, vector<int>(2));
	for (size_t i = 0; i < query_count; i++)
		cin >> queries[i][0] >> queries[i][1];

	//auto original_colors = colors;
	auto solution = bruteforce(graph, colors, queries);
	/*colors = original_colors;
	auto s2 = better_solution(graph, colors, queries);*/
	for(int s: solution)
	{
		cout << s << "\n";
	}

	return 0;
}